/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ConstantBlock;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.NetworkNodeParameter;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import DE.siemens.ad.logo.util.Language;

public class NetworkNodeBlock
extends ConstantBlock {
    private static final long serialVersionUID = -1000372279559524047L;

    public NetworkNodeBlock() {
    }

    public NetworkNodeBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    public String getNumberPrefix() {
        return "NI";
    }

    public int getNumberType() {
        return 22;
    }

    public int getResourceIndex() {
        return 22;
    }

    protected boolean calculateBinaryValue() {
        return ((NetworkNodeParameter)this.getParameter()).getValue();
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[1];
        String name = "DE.siemens.ad.logo.model.NetworkNodeParameter";
        this.fInConnectors[0] = new ParameterInBlockConnector((Block)this, name, "Par");
    }

    protected int getDefaultOrder() {
        return 10100;
    }

    public int[] getMemoryResources(Hardware hardware) {
        int[] result = new int[HardwareFactory.getInstance().getResourceNames().length];
        result[this.getNumberType()] = 1;
        return result;
    }

    public String getType() {
        return "Network";
    }

    public boolean isLeftTerminal() {
        return true;
    }

    public String getNumberString(int blockNumber) {
        String string = blockNumber > 0 ? this.getNumberPrefix() + Integer.toString(blockNumber) : this.getNumberPrefix();
        return string;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        BlockParameter param = this.getParameter();
        if (param != null) {
            param.init(interpreter, forceReset);
        }
    }

    public boolean compareTo(Block otherBlock, DifferenceTableModel differences) {
        if (!super.compareTo(otherBlock, differences)) {
            return false;
        }
        NetworkNodeParameter srcParameter = (NetworkNodeParameter)this.getParameter();
        NetworkNodeParameter tarParameter = (NetworkNodeParameter)otherBlock.getParameter();
        String blockID = this.getNumberString() + " - ";
        if (srcParameter.isForSlave() != tarParameter.isForSlave()) {
            String arcString = srcParameter.isForSlave() ? Language.getString("panel.networkNodePanel.slaveSelection") : Language.getString("block.NetworkNode.vm");
            String tarString = tarParameter.isForSlave() ? Language.getString("panel.networkNodePanel.slaveSelection") : Language.getString("block.NetworkNode.vm");
            String[] str = new String[]{blockID + Language.getString("compare.differentReferenceType", "Reference type"), arcString, tarString};
            Object[] o = new Object[]{this, otherBlock};
            differences.add(str, o);
            return false;
        }
        if (srcParameter.isForSlave()) {
            if (!srcParameter.getAddress().equals(tarParameter.getAddress())) {
                String[] str = new String[]{blockID + Language.getString("block.NetworkNode.remoteIP", "Remote IP"), String.valueOf(srcParameter.getAddress()), String.valueOf(tarParameter.getAddress())};
                Object[] o = new Object[]{this, otherBlock};
                differences.add(str, o);
                return false;
            }
            if (srcParameter.getConfiguredBlockType() != tarParameter.getConfiguredBlockType() || srcParameter.getConfiguredBlockNumber() != tarParameter.getConfiguredBlockNumber()) {
                String[] str = new String[]{blockID + Language.getString("compare.differentReferenceBlockType", "Referenced block"), srcParameter.getBlockAbbreviation(srcParameter.getConfiguredBlockType()) + srcParameter.getConfiguredBlockNumber(), tarParameter.getBlockAbbreviation(tarParameter.getConfiguredBlockType()) + tarParameter.getConfiguredBlockNumber()};
                Object[] o = new Object[]{this, otherBlock};
                differences.add(str, o);
                return false;
            }
        } else if (srcParameter.getVMAddress() != tarParameter.getVMAddress() || srcParameter.getBitNumber() != tarParameter.getBitNumber()) {
            String[] str = new String[]{blockID + Language.getString("tool.vmConfigure.address", "Address"), srcParameter.getAddressText(), tarParameter.getAddressText()};
            Object[] o = new Object[]{this, otherBlock};
            differences.add(str, o);
            return false;
        }
        return true;
    }
}

